#include <a_samp>


#define MAX_AFK_TIME 600
#define AFK_TEXT_SET 2
#define T_COLOR 0xFF000080
#define MK_COLOR 0xFFFFFFFF
#define COLOR_GREY 0xAFAFAFAA
#define T_DIST 20.0

enum afk_info {
AFK_Time,
Float:AFK_Coord,
AFK_Stat
}

new PlayerAFK[MAX_PLAYERS][afk_info];
new AFK_Timer;
new Text3D:AFK_3DT[MAX_PLAYERS];

forward AFKCheck();

public AFKCheck()
{
    new Float:AFKCoords[3];
    for(new i = 0;i<MAX_PLAYERS;i++)
    {
        if(!IsPlayerConnected(i)){continue;}
        if(IsPlayerNPC(i)){continue;}
        GetPlayerPos(i,AFKCoords[0],AFKCoords[1],AFKCoords[2]);
        if(AFKCoords[0] == PlayerAFK[i][AFK_Coord])
        {
            PlayerAFK[i][AFK_Time]++;
        }
        else
        {
            PlayerAFK[i][AFK_Time] = 0;
            if(PlayerAFK[i][AFK_Stat] != 0) { Delete3DTextLabel(AFK_3DT[i]); PlayerAFK[i][AFK_Stat] = 0; }
        }
        PlayerAFK[i][AFK_Coord] = AFKCoords[0];
        if(PlayerAFK[i][AFK_Time] == AFK_TEXT_SET && PlayerAFK[i][AFK_Stat] == 0)
        {
            AFK_3DT[i] = Create3DTextLabel("{ff8800}AFK: {ffffff}0/600 {ff8800}", T_COLOR, 0.00, 0.00, 10000.0, T_DIST, 0);
            Attach3DTextLabelToPlayer(AFK_3DT[i], i, 0.0, 0.0, 0.3);
            PlayerAFK[i][AFK_Stat] = 1;
        }
        if(PlayerAFK[i][AFK_Stat] == 1)
        {
           new str[256]; format(str,256,"{ff8800}AFK: {ffffff}%d/600 {ff8800}",PlayerAFK[i][AFK_Time]);
           Update3DTextLabelText(AFK_3DT[i], T_COLOR, str);
        }
        if(IsPlayerAdmin(i)){continue;}//      
    }
    return 1;
}

public OnFilterScriptInit()
{
    AFK_Timer = SetTimer("AFKCheck",1000,1);
    return 1;
}

public OnFilterScriptExit()
{
    for(new i=0;i<MAX_PLAYERS;i++)
    {
        Delete3DTextLabel(AFK_3DT[i]);
    }

    KillTimer(AFK_Timer);
    return 1;
}


public OnPlayerConnect(playerid)
{
    PlayerAFK[playerid][AFK_Time] = 0;
    PlayerAFK[playerid][AFK_Stat] = 0;
    return 1;
}

public OnPlayerDisconnect(playerid, reason)
{
    PlayerAFK[playerid][AFK_Time] = 0;
    if(PlayerAFK[playerid][AFK_Stat] != 0) { Delete3DTextLabel(AFK_3DT[playerid]); PlayerAFK[playerid][AFK_Stat] = 0; }
    return 1;
}
